/*** main.c
    Eric R. Weeks, John M. Burgess
    http://chaos.ph.utexas.edu/~weeks/dsane/

    (weeks@chaos.ph.utexas.edu, jburgess@chaos.ph.utexas.edu)

version 1.0: April 8, 1997.

This program works with the following files:
   dsane.c
   fitness.c
   usermap.c
   network.c
   sane.h
   params.h

    ***/

#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "params.h"
#include "dsane.h"


/*Global variables**************************************/
char *suffix;
defnnet olddefn[MAXNET],newdefn[MAXNET];  /* defn's for best networks */
int opernum[OPNUM]; /* There are OPNUM different types of mutation */
int nextuniqidnum=1;
int uniqnum[POP_SIZE];




/* ---- command line flags ---- */
/***** MAP                                                    *****/
float parameter=1.29;	     /* initial control parameter   (-p:) */
float deltapmax[2];	     /* initial deltapmax value	   (-eE:) */
float noiselevel = 0.001;    /* level of noise	            (-N:) */
int numsteps = 1000;         /* map iterations              (-l:) */
int themap = HENON;	     /* henon map is default	    (-M:) */
/***** FITNESS EVALUATION				      *****/
int numtrials = 100;         /* how many nets to form/gen   (-t:) */
int doublecheck = 2;	     /* # of times to check fitness (-D:) */
int period = 1;	       	     /* find period-1 fixed point   (-T:) */
/***** OUTPUT						      *****/
int printsteps =   0;        /* print last 0 iterations     (-y:) */
/***** DIRECTED SANE    				      *****/
int netdefnnum = 4;	     /* save 4 network defn's       (-z:) */
int maxdefnuse;       /* number of nets to create from net defn's */



void main(int argc, char *argv[])
{
    newneuron actual_pop[POP_SIZE],*pop[POP_SIZE];
    int i,j;
    int preserve;
    extern int optind;
    extern char *optarg;
    FILE *parameter_file;
    /***** EVOLUTION					          *****/
    int maxgen = 2000;           /* number of generations       (-g:) */
    float stopfit = 1950.0;      /* stop when above this fitness      */
    float fracdefnuse = 50.0;    /* form half of nets w/ defn's (-Z:) */
    /***** CONTROL       				          *****/
    deltapmax[0] = 0.010;        /*			        (-e:) */
    deltapmax[1] = 0.000;        /*			        (-E:) */

    reseed(time(NULL));



while ((i=getopt(argc, argv,
   "hp:r:e:g:N:t:D:z:Z:s:l:M:y:E:T:"))!=EOF)
     switch (i)  {
    case 'h':  fprintf(stderr,"Usage: %s [options] suffix\n",argv[0]);
fprintf(stderr,"THE MAP:\n");
fprintf(stderr," -p # : parameter value [%.2f]\n",parameter);
fprintf(stderr," -e # : deltapmax 1 [%.4f]\n",deltapmax[0]);
fprintf(stderr," -E # : deltapmax 2 [%.4f]\n",deltapmax[1]);
fprintf(stderr," -N # : noise level # [%f]\n",noiselevel);
fprintf(stderr," -M # : set map (%d=logistic %d=henon %d=user) [%d]\n",
      LOGISTIC,HENON,USERMAP,themap);
fprintf(stderr,"FITNESS EVALUATION:\n");
fprintf(stderr," -l # : how many times to iterate map [%d]\n",numsteps);
fprintf(stderr," -t # : number of trials/generation (networks formed) [%d]\n",numtrials);
fprintf(stderr," -D # : doublecheck--test network # times [%d]\n",doublecheck);
fprintf(stderr," -T # : look for period-# [%d] fixed point\n",period);
fprintf(stderr,"OUTPUT:\n");
fprintf(stderr," -y # : for dynamics file: print last # steps [%d]\n",printsteps);
fprintf(stderr," -s # : stop when fitness exceeds this value [%.1f]\n",stopfit);
fprintf(stderr,"EVOLUTION:\n");
fprintf(stderr," -g # : maximum generations [%d]\n",maxgen);
fprintf(stderr," -z # : save defn's of best # networks [%d]\n",netdefnnum);
fprintf(stderr," -Z # : %%age of nets to form according to defn's [%.1f]\n",fracdefnuse);
fprintf(stderr,"MISC:\n");
fprintf(stderr," -r # : reseed random number generator [default:time]\n");
	    exit(1);
	    break;
    case 'p': parameter = atof(optarg);
	    break;
    case 'r': reseed(atoi(optarg));
	    break;
    case 'e': deltapmax[0] = atof(optarg);
	    break;
    case 'E': deltapmax[1] = atof(optarg);
	    break;
    case 'g': maxgen = atoi(optarg);
	    break;
    case 'N': noiselevel = atof(optarg);
	    break;
    case 't': numtrials = atoi(optarg);
	    break;
    case 'D': doublecheck = atoi(optarg);
	    break;
    case 'z': netdefnnum = atoi(optarg);
	    if (netdefnnum>MAXNET)  {
		printf("-z option limited to %d\n",MAXNET);
		exit(1);
	    }
	    break;
    case 'Z': fracdefnuse = atof(optarg);
	    break;
    case 's': stopfit = atof(optarg);
	    break;
    case 'l': numsteps = atoi(optarg);
	    break;
    case 'M': themap = atoi(optarg);
	    break;
    case 'y': printsteps = atoi(optarg);
	    break;
    case 'T': period = atoi(optarg);
	    break;
    }

    argc -= (optind-1) ; argv += (optind-1) ;
    if (argc > 1)  {
	suffix = *++argv;
    } else {
	printf("No suffix?  Use -h option for help\n");
	exit(0);
    }

    preserve=initialize_dsane(fracdefnuse,numtrials);

    /* some output */
    parameter_file = openfile("para","w");
    fprintf(parameter_file,"command line options:\n");
    fprintf(parameter_file,"map used                  : %d\n",themap);
    fprintf(parameter_file,"   (1=logistic 2=henon 3=user map)\n");
    fprintf(parameter_file,"number of Generations max : %d\n",maxgen);
    fprintf(parameter_file,"# of net defns to save    : %d\n",netdefnnum);
    fprintf(parameter_file,"# of net defns to use     : %d\n",maxdefnuse);
    fprintf(parameter_file,"# of Map steps per net    : %d\n",numsteps);
    fprintf(parameter_file,"parameter                 : %f\n",parameter);
    fprintf(parameter_file,"delta P 0 max             : %f\n",deltapmax[0]);
    fprintf(parameter_file,"delta P 1 max             : %f\n",deltapmax[1]);
    fprintf(parameter_file,"noise level               : %f\n",noiselevel);
    fprintf(parameter_file,"use double-check?         : %d\n",doublecheck);
    fprintf(parameter_file,"find period               : %d\n",period);
    fprintf(parameter_file,"# of nets formed per Gen  : %d\n",numtrials);
    fprintf(parameter_file,"stop when fitness exceeds : %.0f\n",stopfit);

    fprintf(parameter_file,"\nThese are set in params.h:\n");
    fprintf(parameter_file,"size of population        : %d\n",POP_SIZE);
    fprintf(parameter_file,"neurons in input layer    : %d\n",NUM_INPUTS);
    fprintf(parameter_file,"neurons in hidden layer   : %d\n",ZETA);
    fprintf(parameter_file,"neurons in output layer   : %d\n",NUM_OUTPUTS);
    fprintf(parameter_file,"number of mutations       : %d\n",opernum[1]*4);
    fprintf(parameter_file,"number of crossover       : %d\n",opernum[0]);
    fprintf(parameter_file,"number preserved          : %d\n",preserve);
    fflush(parameter_file);
    fclose(parameter_file);

    for (i=0;i<POP_SIZE;++i)  pop[i] = &actual_pop[i];
    create_pop(pop);
    evolve(pop,maxgen,preserve,stopfit);
} /* END OF MAIN */






/** reseed seeds the lrand48() function.
     **/

void reseed(int val)
{
  unsigned short seed[3];

  seed[0] = ((unsigned short)val);
  seed[1] = ((unsigned short)val+1);
  seed[2] = ((unsigned short)val+2);
  seed48(seed);
}


/* The following function is taken from Ray Goldstein's computer program
 * to handle file suffixes.
 */


FILE *openfile(char *name, char *status)
{
    FILE *fp;
    char fullname[100];

    strcat(strcat(strcpy(fullname, name), "."), suffix);
    if((fp = fopen(fullname, status)) == NULL)  {
	fprintf(stderr, "Can't open %s!\n", fullname);
	exit(0);
    }
    return fp;
}







