/**********************************/
/*----------dsane.h---------------*/
/**********************************/

/* For use with dsane.c, Eric R. Weeks & John M Burgess    */
/* weeks@chaos.ph.utexas.edu, jburgess@chaos.ph.utexas.edu */
/*
 * version 1.0: April 8, 1997
 */


/* ---------- DSANE definitions ---------- */
#define MAXNET     500      /* max number net defn's that can be stored */
#define OPNUM	5   	    /* how many operators exist? */
#define MAX_CONNECTIONS 20  /* maximum neurons in a layer */
#define NEWNUMBER 60        /* number of weights to store per gene */

/* for reasons of "it works", we need NEWNUMBER to be at least four
times as big as NUM_INPUTS+NUM_OUTPUTS.  The only place where this
is critical is the mutation operator; we find that storing the weights
in four pieces (see below for "newneuron" description) results in
a faster mutation.  Faster in the sense that the evolution takes place
much faster. */


/* various flags for internal use -- no need to ever modify these */
#define NOPRINT 0.0
#define LOGISTIC 1         /* values for "themap" variable */
#define HENON 2
#define USERMAP 3
#define DONOT_PRINTFITNESS -1.0


/*node definition ********************************/
/* for use in defining a neural network */
typedef struct {
   float weight[MAX_CONNECTIONS]; /*weight of connection*/
   float outwt[MAX_CONNECTIONS];  /* output weights for hidden nodes */
   float sum;                     /*holds total activation*/
   float sigout;                  /*output from sigmoid (if used)*/
 } node;


/*network definition*****************************/
typedef struct {
  float input_unit[NUM_INPUTS];
  node hidden_unit[ZETA];
  node output_unit[NUM_OUTPUTS];
} network;


/* gene/neuron stucture ******************************/
/* we call this "newneuron" to distinguish it from the
 * original SANE neuron structure.  The primary difference
 * is the change to floating point weights.  The secondary
 * difference is the addition of idnum's for use with
 * Directed SANE.  The variables "label" and "weight" are needed
 * to handle mutation correctly, we find.
 */
typedef struct {
   node neuron;		    /* the actual weights */
   int label[NEWNUMBER];    /* holdover from original SANE */
   float weight[NEWNUMBER]; /* holdover from original SANE */
   float fitness;           /* neuron's fitness value */
   int tests;               /* holds the total # of networks participated in */
   int method;              /* method used to create this neuron */
   int birth;               /* when was this neuron formed? */
   int idnum;               /* identifies this neuron (where it's from) */
   int newidnum;            /* neuron's new name (where it is) */
 } newneuron;



/* directed sane network defn ***************/
typedef struct {
	int idnet[ZETA];		/* ptrs to genes */
	float fitness;			/* how good's this defn? */
} defnnet;



/*Function declarations*************************/

/* MAIN.C */
void main(int argc,char *argv[]);
void reseed(int val);
FILE *openfile(char *name,char *status);

/* DSANE.C */
int initialize_dsane(float a, int b);
void create_pop(newneuron* new_pop[]);
void decode_gene(newneuron *gene);
void evolve(newneuron* pop[],int cycles, int preserve, float stopfit);
int mutate(newneuron* pop[], int max, int replace, float level, int number, int methodused);
int crossover(newneuron* pop[], int max, int replace, int number);
void qsort_neurons(newneuron* pop[],int p,int r);
int qpartition_neurons(newneuron* pop[],int p,int r);
void eval_pop(newneuron* pop[],int generation,float stopfit);
void getfitness(network* net_ptr, float* fitness,int numsteps);
void activate_net(network* net);
void printoutwts(node *neuron,FILE *filename);
void print_pop(newneuron* pop[]);
void print_network(network* net,float fitness);
void exit_program(newneuron *pop[], network *bestnet);

/* FITNESS.C */
float find_fitness(network *net,int numsteps,float oldfitness);
float apply_action(float x,float extravars[],float parameter,float deltaP[]);
void neteval(network* net);
void setup_initial_state(float *x, float extravars[],float deltaP[]);

/* NETWORK.C */
void get_deltaP(network *net, float deltaP[], float deltapmax[]);
void setup_input(network *net,float xlag[], float plag[]);

/* USERMAP.C */
void usermap(float *x_next,float extravars[],float deltaP[],float P, float noise);
void initialize_usermap(float *x, float extravars[]);

