/********************************************/
/*-----------usermap.c----------------------*/
/********************************************/

/* For use with dsane.c, Eric R. Weeks & John M Burgess    */
/* weeks@chaos.ph.utexas.edu, jburgess@chaos.ph.utexas.edu */
/*
 * version 1.0: April 8, 1997
 */

#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include "params.h"
#include "dsane.h"

/* In the two functions below, the variable "x" is the one seen by
 * the neural network.  The array extravars[] contains any variables
 * hidden from the network.
 *
 * If you want the map dependent on iteration number, you can use one
 * of these extra variables.  For example, initialize extravars[1] to be
 * 0 in the function initialize_usermap(), and then have the function
 * usermap() contain the command "extravars[1]++".
 *
 * Right now extravars[] has a size of 10, which ought to be more
 * than enough!  If you need to change it, change the declaration which
 * is in fitness.c.
 */

/* this particular map came from: K. Konishi and H. Kokame, "Control of
 * chaotic systems using an on-line trained linear neural controller,"
 * Physica D 100 (1997) 423.  They use parameter=3.7 and apply
 * perturbations to both the X and Y variables.  Their perturbations
 * are not limited in size.
 */
void usermap(float *x, float extravars[], float deltaP[], float parameter, float noiselevel)
{
    float x_next;

    x_next = (parameter - (*x) - 0.1*extravars[0])*(*x);
    extravars[0] = (parameter - 0.15*(*x) - extravars[0])*extravars[0];
    x_next += deltaP[0] + (drand48()-0.5)*noiselevel;
    extravars[0] += deltaP[1];
    *x = x_next;
}


void initialize_usermap(float *x, float extravars[])
{
    (*x) = drand48();
    extravars[0] = drand48();
}

