/********************************************/
/*-----------network.c----------------------*/
/********************************************/
/* For use with dsane.c, Eric R. Weeks & John M Burgess    */
/* weeks@chaos.ph.utexas.edu, jburgess@chaos.ph.utexas.edu */
/*
 * version 1.0: April 8, 1997
 */

#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include "params.h"
#include "dsane.h"


/* -------- this converts the output layer into values for deltaP ------- */
void get_deltaP(network* net, float deltaP[], float deltaPmax[])
{
    deltaP[0] = deltaPmax[0] * (((net->output_unit[0].sigout) * 2.0) - 1.0);
    if (NUM_OUTPUTS>1)
	deltaP[1] = deltaPmax[1] * (((net->output_unit[1].sigout) * 2.0) - 1.0);
}

/* ============================================================ */
/* ============================================================ */

/** ------- setup_input assigns values to the network's input layer. -----
xlag[0] = this step     (x_n)
xlag[1] = previous step (x_n-1)
xlag[2] = before that   (x_n-2)
    **/
void setup_input(network* net,float xlag[],float plag[])
{
    int i;

    for (i=0;i<NUM_INPUTS;i++)
	net->input_unit[i] = xlag[i];

/*  SOME OTHER POSSIBILITIES:
    net->input_unit[4] = 1.0;
    net->input_unit[5] = plag[0];
    net->input_unit[6] = drand48();
*/
}

