FUNCTION special_char

special_char = strarr(6)
special_char[0] = '\'
special_char[1] = '{'
special_char[2] = '}'
special_char[3] = '_'
special_char[4] = '$'
special_char[5] = ' '


return, special_char

END

FUNCTION math_symbols, tex_code

idl_code = ''

;special characters 
IF strcmp(tex_code, '\cdot') THEN idl_code = string("267b)
IF strcmp(tex_code, '\langle') THEN idl_code = '!9'+string("341b)+'!7'
IF strcmp(tex_code, '\rangle') THEN idl_code = '!9'+string("361b)+'!7'
IF strcmp(tex_code, '\|') THEN idl_code = '!S|!R!U !N|';"
IF strcmp(tex_code, '\nabla') THEN idl_code = '!9'+string("321b);"
IF strcmp(tex_code, '\pm') THEN idl_code = '!9'+string("261b);"
IF strcmp(tex_code, '\leq') THEN idl_code = '!9'+string("243b);"
IF strcmp(tex_code, '\geq') THEN idl_code = '!9'+string("263b);"
IF strcmp(tex_code, '\approx') THEN idl_code = '!9'+string("273b);"
IF strcmp(tex_code, '\partial') THEN idl_code = '!9'+string("266b);"
IF strcmp(tex_code, '\int') THEN idl_code = '!S!9'+string("362b)+'!R!I   !N';"
IF strcmp(tex_code, '\infty') THEN idl_code = '!9'+string("245b);"
IF strcmp(tex_code, '\propto') THEN idl_code = '!9'+string("265b);"
IF strcmp(tex_code, '\equiv') THEN idl_code = '!9'+string("272b);"
IF strcmp(tex_code, '\sim') THEN idl_code = '!9'+string("176b);"
IF strcmp(tex_code, '\cong') THEN idl_code = '!9'+string("100b);"
IF strcmp(tex_code, '\times') THEN idl_code = '!9'+string("264b);"
IF strcmp(tex_code, '\{') THEN idl_code = '!9'+string("173b);"
IF strcmp(tex_code, '\}') THEN idl_code = '!9'+string("175b);"
IF strcmp(tex_code, '\angle') THEN idl_code = '!9'+string("320b);"
IF strcmp(tex_code, '\Re') THEN idl_code = '!9'+string("302b);"
IF strcmp(tex_code, '\Im') THEN idl_code = '!9'+string("301b);"
IF strcmp(tex_code, '\perp') THEN idl_code = '!9'+string("136b);"
IF strcmp(tex_code, '\para') THEN idl_code = '!S|!R!U !N|';"
IF strcmp(tex_code, '\rightarrow') THEN idl_code = '!9'+string("256b);"
IF strcmp(tex_code, '\leftarrow') THEN idl_code = '!9'+string("254b);"
IF strcmp(tex_code, '\uparrow') THEN idl_code = '!9'+string("255b);"
IF strcmp(tex_code, '\downarrow') THEN idl_code = '!9'+string("257b);"
IF strcmp(tex_code, '\lefrighttarrow') THEN idl_code = '!9'+string("253b);"
IF strcmp(tex_code, '\Rightarrow') THEN idl_code = '!9'+string("336b);"
IF strcmp(tex_code, '\Leftrightarrow') THEN idl_code = '!9'+string("333b);"
IF strcmp(tex_code, '\Uparrow') THEN idl_code = '!9'+string("335b);"
IF strcmp(tex_code, '\Downarrow') THEN idl_code = '!9'+string("337b);"
IF strcmp(tex_code, '\Leftarrow') THEN idl_code = '!9'+string("334b);"
IF strcmp(tex_code, '\prod') THEN idl_code = '!9'+string("325b);"
IF strcmp(tex_code, '\sum') THEN idl_code = '!9'+string("345b);"
IF strcmp(tex_code, '\ldots') THEN idl_code = '!9'+string("274b);"


;Set Theory
IF strcmp(tex_code, '\subset') THEN idl_code = '!9'+string("314b);"
IF strcmp(tex_code, '\subseteq') THEN idl_code = '!9'+string("315b);"
IF strcmp(tex_code, '\supset') THEN idl_code = '!9'+string("311b);"
IF strcmp(tex_code, '\supseteq') THEN idl_code = '!9'+string("312b);"
IF strcmp(tex_code, '\in') THEN idl_code = '!9'+string("316b);"
IF strcmp(tex_code, '\emotyset') THEN idl_code = '!9'+string("306b);"
IF strcmp(tex_code, '\cap') THEN idl_code = '!9'+string("307b);"
IF strcmp(tex_code, '\cup') THEN idl_code = '!9'+string("310b);"
IF strcmp(tex_code, '\exist') THEN idl_code = '!9'+string("044b);"
IF strcmp(tex_code, '\forall') THEN idl_code = '!9'+string("042b);"




;Functions
IF strcmp(tex_code, '\sin') THEN idl_code = '!7sin'
IF strcmp(tex_code, '\cos') THEN idl_code = '!7cos'
IF strcmp(tex_code, '\tan') THEN idl_code = '!7tan'
IF strcmp(tex_code, '\sec') THEN idl_code = '!7sec'
IF strcmp(tex_code, '\csc') THEN idl_code = '!7csc'
IF strcmp(tex_code, '\cot') THEN idl_code = '!7cot'
IF strcmp(tex_code, '\sinh') THEN idl_code = '!7sinh'
IF strcmp(tex_code, '\cosh') THEN idl_code = '!7sosh'
IF strcmp(tex_code, '\tanh') THEN idl_code = '!7tanh'
IF strcmp(tex_code, '\sech') THEN idl_code = '!7sech'
IF strcmp(tex_code, '\csch') THEN idl_code = '!7csch'
IF strcmp(tex_code, '\coth') THEN idl_code = '!7coth'
IF strcmp(tex_code, '\ln') THEN idl_code = '!7ln'
IF strcmp(tex_code, '\log') THEN idl_code = '!7log'
IF strcmp(tex_code, '\exp') THEN idl_code = '!7exp'
IF strcmp(tex_code, '\sup') THEN idl_code = '!7sup'
IF strcmp(tex_code, '\inf') THEN idl_code = '!7inf'
IF strcmp(tex_code, '\max') THEN idl_code = '!7max'
IF strcmp(tex_code, '\lim') THEN idl_code = '!7lim'
IF strcmp(tex_code, '\liminf') THEN idl_code = '!7lim inf'
IF strcmp(tex_code, '\limsup') THEN idl_code = '!7lim sup'
IF strcmp(tex_code, '\det') THEN idl_code = '!7det'
IF strcmp(tex_code, '\ker') THEN idl_code = '!7ker'
IF strcmp(tex_code, '\dim') THEN idl_code = '!7dim'
IF strcmp(tex_code, '\gcd') THEN idl_code = '!7gcd'
IF strcmp(tex_code, '\arg') THEN idl_code = '!7arg'









;greek letters
IF strcmp(tex_code, '\Alpha') THEN idl_code = '!9A'
IF strcmp(tex_code, '\alpha') THEN idl_code = '!9a'
IF strcmp(tex_code, '\Beta') THEN idl_code = '!9B'
IF strcmp(tex_code, '\beta') THEN idl_code = '!9b'
IF strcmp(tex_code, '\Gamma') THEN idl_code = '!9G'
IF strcmp(tex_code, '\gamma') THEN idl_code = '!9g'
IF strcmp(tex_code, '\Tau') THEN idl_code = '!9T'
IF strcmp(tex_code, '\tau') THEN idl_code = '!9t'
IF strcmp(tex_code, '\Epsilon') THEN idl_code = '!9E'
IF strcmp(tex_code, '\epsilon') THEN idl_code = '!9e'
IF strcmp(tex_code, '\Delta') THEN idl_code = '!9D'
IF strcmp(tex_code, '\delta') THEN idl_code = '!9d'
IF strcmp(tex_code, '\Zeta') THEN idl_code = '!9Z'
IF strcmp(tex_code, '\zeta') THEN idl_code = '!9z'
IF strcmp(tex_code, '\Nu') THEN idl_code = '!9N'
IF strcmp(tex_code, '\nu') THEN idl_code = '!9n'
IF strcmp(tex_code, '\Phi') THEN idl_code = '!9F'
IF strcmp(tex_code, '\phi') THEN idl_code = '!9f'
IF strcmp(tex_code, '\Theta') THEN idl_code = '!9Q'
IF strcmp(tex_code, '\theta') THEN idl_code = '!9q'
IF strcmp(tex_code, '\Mu') THEN idl_code = '!9M'
IF strcmp(tex_code, '\mu') THEN idl_code = '!9m'
IF strcmp(tex_code, '\Iota') THEN idl_code = '!9I'
IF strcmp(tex_code, '\iota') THEN idl_code = '!9i'
IF strcmp(tex_code, '\Kappa') THEN idl_code = '!9K'
IF strcmp(tex_code, '\kappa') THEN idl_code = '!9k'
IF strcmp(tex_code, '\Lambda') THEN idl_code = '!9L'
IF strcmp(tex_code, '\lambda') THEN idl_code = '!9l'
IF strcmp(tex_code, '\Pi') THEN idl_code = '!9P'
IF strcmp(tex_code, '\pi') THEN idl_code = '!9p'
IF strcmp(tex_code, '\Upsilon') THEN idl_code = '!9U'
IF strcmp(tex_code, '\upsilon') THEN idl_code = '!9u'
IF strcmp(tex_code, '\Eta') THEN idl_code = '!9H'
IF strcmp(tex_code, '\eta') THEN idl_code = '!9h'
IF strcmp(tex_code, '\Xi') THEN idl_code = '!9X'
IF strcmp(tex_code, '\xi') THEN idl_code = '!9x'
IF strcmp(tex_code, '\Omicron') THEN idl_code = '!9O'
IF strcmp(tex_code, '\omicron') THEN idl_code = '!9o'
IF strcmp(tex_code, '\Rho') THEN idl_code = '!9R'
IF strcmp(tex_code, '\rho') THEN idl_code = '!9r'
IF strcmp(tex_code, '\Sigma') THEN idl_code = '!9S'
IF strcmp(tex_code, '\sigma') THEN idl_code = '!9s'
IF strcmp(tex_code, '\Psi') THEN idl_code = '!9Y'
IF strcmp(tex_code, '\psi') THEN idl_code = '!9y'
IF strcmp(tex_code, '\Chi') THEN idl_code = '!9C'
IF strcmp(tex_code, '\chi') THEN idl_code = '!9c'
IF strcmp(tex_code, '\Omega') THEN idl_code = '!9W'
IF strcmp(tex_code, '\omega') THEN idl_code = '!9w'










return, idl_code

END





FUNCTION ktex2idl, tex_code

; this is from times_font which is how Ken originally coded it.

!p.font = 1
device, set_font='Times', /tt_font


special_char = special_char()
idl_code = '!7!N'

font_status = '!7'
placement = '!N'

place = 0

WHILE place LT strlen(tex_code) DO BEGIN

   flag = 0
   ;print, strmid(tex_code, place, 1)

   IF strcmp(strmid(tex_code, place, 1), '$') THEN BEGIN 
      
      IF strcmp(strmid(font_status, 0, 2), '!7') THEN BEGIN 
         
         font_status = '!8'
         idl_code = idl_code+font_status
         
      ENDIF ELSE BEGIN 

         font_status = '!7'
         idl_code = idl_code+font_status
         
      ENDELSE

      flag = 1
      
   ENDIF  

   IF strcmp(strmid(tex_code, place, 1), '\') THEN BEGIN 

      IF ~strcmp(strmid(tex_code, place, 5), '\sqrt') THEN BEGIN 
         
         flag2 = 0
         place2 = place+1
         WHILE flag2 EQ 0 AND place2 LT strlen(tex_code) DO BEGIN 
            
            IF strcmp(strmid(tex_code, place2, 1), '\') THEN flag2 = 1
            IF strcmp(strmid(tex_code, place2, 1), ' ') THEN flag2 = 1
            IF strcmp(strmid(tex_code, place2, 1), '{') THEN flag2 = 1
            IF strcmp(strmid(tex_code, place2, 1), '}') THEN flag2 = 1
            IF strcmp(strmid(tex_code, place2, 1), '$') THEN flag2 = 1
            IF strcmp(strmid(tex_code, place2, 1), '_') THEN flag2 = 1
            IF strcmp(strmid(tex_code, place2, 1), '(') THEN flag2 = 1
            IF strcmp(strmid(tex_code, place2, 1), ')') THEN flag2 = 1
            IF strcmp(strmid(tex_code, place2, 1), '^') THEN flag2 = 1
            
            place2 = place2+1
            
         ENDWHILE
         
         tmp = strmid(tex_code, place, place2-place-1)
         idl_code = idl_code+math_symbols(tmp)+font_status+placement
         
         flag = 1
         place = place2-2
         
      ENDIF ELSE BEGIN 
         
         flag2 = 0
         place2 = place+5
         
         IF strcmp(strmid(tex_code, place2, 1), '{') THEN BEGIN 
            
            WHILE place2 LT strlen(tex_code) AND flag2 EQ 0 DO BEGIN 
               IF strcmp(strmid(tex_code, place2, 1), '}') THEN flag2 = 1
               place2 = place2+1
            ENDWHILE 
            
            tmp = strmid(tex_code, place+6, place2-place-7)

            ;Number of greek letters
            
            tmp_pos = [kstrpos(tmp,'\'), strlen(tmp)]
            
            n_math = 0
            IF tmp_pos[0] NE -1 THEN BEGIN 
               FOR hhh = 0, length(tmp_pos)-1 DO BEGIN 
                  IF strcmp(math_symbols(strmid(tmp, tmp_pos[0]+1, tmp_pos[1]-2)),'') NE 0 THEN BEGIN 
                     n_math = n_math + (tmp_pos[1]-tmp_pos[0]-3)
                  ENDIF
               ENDFOR
            ENDIF
            ;IF n_math NE 0 THEN n_math = n_math-1

            idl_code = idl_code+'!S!9'+string("326b)+'!R!9'+string("140b)+'!S!9'
            FOR ii = 1, strlen(tmp)-1-n_math DO BEGIN 
               idl_code = idl_code+string("140b) ;"
            ENDFOR 
            idl_code = idl_code+'!R!8';+tmp
            
            place = place+5
            flag = 1
            
         ENDIF ELSE BEGIN 
            
            idl_code = idl_code+'!S!9'+string("326b)+'!R!9'+string("140b)
            
            place = place2-1
            flag = 1
            
         ENDELSE
         
      ENDELSE 

   ENDIF 

   IF strcmp(strmid(tex_code, place, 1), '_') THEN BEGIN 

      IF ~strcmp(strmid(tex_code, place+1, 1), '{') THEN BEGIN 
         idl_code = idl_code + '!D'+strmid(tex_code, place+1, 1)+'!N'
         place = place+1
      ENDIF

      IF strcmp(strmid(tex_code, place+1, 1), '{') THEN BEGIN 
         placement = '!D'
         idl_code = idl_code + placement
      ENDIF       

      flag = 1

   ENDIF
 
   IF strcmp(strmid(tex_code, place, 1), '^') THEN BEGIN 

      IF ~strcmp(strmid(tex_code, place+1, 1), '{') THEN BEGIN 
         idl_code = idl_code + '!E'+strmid(tex_code, place+1, 1)+'!N'
         place = place+1
      ENDIF

      IF strcmp(strmid(tex_code, place+1, 1), '{') THEN BEGIN 
         placement = '!E'
         idl_code = idl_code + placement
      ENDIF       

      flag = 1

   ENDIF
  
   IF strcmp(strmid(tex_code, place, 1), '{') THEN flag = 1
   IF strcmp(strmid(tex_code, place, 1), '}') THEN flag = 1

   IF strcmp(strmid(tex_code, place, 1), '}') AND $
      strcmp(strmid(placement, 0, 2), '!D') THEN BEGIN 
      placement = '!N'
      idl_code = idl_code + placement
      flag = 1
   ENDIF 

   IF strcmp(strmid(tex_code, place, 1), '}') AND $
      strcmp(strmid(placement, 0, 2), '!E') THEN BEGIN 
      placement = '!N'
      idl_code = idl_code + placement
      flag = 1
   ENDIF    


   IF flag EQ 0 THEN idl_code = idl_code + strmid(tex_code, place, 1)


   place = place + 1

ENDWHILE 



return, idl_code

END
