; cropjpg	Eric R. Weeks, 8-23-2016
;
; This procedure reads in a JPG file which is typically a graph
; (or multiple graphs) on a *WHITE* background.  It then looks for
; the min & max pixel locations in X and Y that are not white.  It
; crops the image to that minimal size, and then writes the cropped
; image to the same filename.
;
; use /INVERSE to assume the background is BLACK and to look for
; the cropped image capturing the portion of the image that is
; not black.
;
; Note that the file name "fname" can include wildcards to
; crop multiple files in one go.
;
; LIMITATION:  As currently written, assumes JPG is a color file.

pro cropjpg,fname,inverse=inverse

f=findfile(fname,count=nf)

for i=0,nf-1 do begin
	read_jpeg,f[i],a
	aa=min(a,dim=1)
	ax=min(aa,dim=2)
	ay=min(aa,dim=1)
	nx=n_elements(ax)
	ny=n_elements(ay)
	if (not keyword_set(inverse)) then begin
		w=where(ax lt 255,nw)
	endif else begin
		w=where(ax gt 0,nw)
	endelse
	if (nw gt 0) then begin
		xx1=(w[0]-1) > 0
		xx2=w[-1]+1 < (nx-1)
	endif else begin
		xx1=0 & xx2=(nx-1)
	endelse
	if (not keyword_set(inverse)) then begin
		w=where(ay lt 255,nw)
	endif else begin
		w=where(ay gt 0,nw)
	endelse
	if (nw gt 0) then begin
		yy1=(w[0]-1) > 0
		yy2=w[-1]+1 < (ny-1)
	endif else begin
		yy1=0 & yy2=(nx-1)
	endelse
	write_jpeg,f[i],a(*,xx1:xx2,yy1:yy2),true=1,quality=100
endfor

end
