function readtiffstack, file

; function kreadtiffstack, file
;  
; Purpose: Read in tiff stacks. Does so by a round about method
; 
; Written by Kenneth Desmond on Jan, 7. 2009
; 
; 




out = -1

if strcmp(strmid(file,strlen(file)-4,4),'.tif') then begin 

   ;Convert tiffs to png
   spawn, 'convert '+file+' '+strmid(file,0,strlen(file)-4)+'.png'

   ;Get list of converted tiff files
   png_files = file_search(strmid(file,0,strlen(file)-5)+'*.png')

   ;Cycle through all files loading in each image individually
   for i = 0, n_elements(png_files)-1 do begin 
      spawn, 'convert '+png_files[i]+' '+ $
             strmid(png_files[i],0,strlen(png_files[i])-4)+'.pdf'
      a = read_pdf(strmid(png_files[i],0,strlen(png_files[i])-4)+'.pdf')
      a = reform((float(a[*,*,0]) + a[*,*,1] + a[*,*,2])/3)

      if i eq 0 then  out = make_array(n_elements(a[*,0]), $
                                       n_elements(a[1,*]), $
                                       n_elements(png_files))

      out[*, *, i] = a

      spawn, 'rm '+ png_files[i]
      spawn, 'rm '+ strmid(png_files[i],0,strlen(png_files[i])-4)+'.pdf'

   endfor

end

if strcmp(strmid(file,strlen(file)-5,5),'.tiff') then begin 


   spawn, 'convert '+file+' '+strmid(file,0,strlen(file)-5)+'.png'

   png_files = file_search(strmid(file,0,strlen(file)-6)+'*.png')
   
   for i = 0, n_elements(png_files)-1 do begin 
      spawn, 'convert '+png_files[i]+' '+ $
             strmid(png_files[i],0,strlen(png_files[i])-5)+'.pdf'
      a = read_pdf(strmid(png_files[i],0,strlen(png_files[i])-5)+'.pdf')
      a = reform((float(a[*,*,0]) + a[*,*,1] + a[*,*,2])/3)

      if i eq 0 then  out = make_array(n_elements(a[*,0]), $
                                       n_elements(a[1,*]), $
                                       n_elements(png_files))

      out[*, *, i] = a

      spawn, 'rm '+ png_files[i]
      spawn, 'rm '+ strmid(png_files[i],0,strlen(png_files[i])-5)+'.pdf'

   endfor

end


if n_elements(out) eq 1 then print, '% file must end with .tif or .tiff'

return, bytscl(out)


end
