;function makepdf,tracks,dt,dim=dim,erode=erode,careful=careful
;
;	'tracks' is either the output from 'track' or the name of
;	a 'gdf' file which is. If there are multiple files hit by
;	the filename, the results are pooled automatically.
;
;	'dt' is a single number in the same units as in 'tracks' 
;	and 'dim' is the dimensionality of the space.
;
;	Set 'erode' to cut out events near trajectory ends and gaps,
;	yielding more accurate tracks. Set 'careful' to never 
;	overcount the data, yeilding fewer, but independent data.
;	
;	The output is a [dim,nsamples] array, e.g. two columns for
;	'dx' and 'dy' data.
;
pro ltrinterp,tarray
;
; 	started 6-17-98 by ERW, modified for use here 6/99 by JCC
;	interpolates gaps in tracked data (time,id only), zeros elsewhere
; 	tarray is an array of tracked data
;
ndat=n_elements(tarray(*,0))
dp=tarray-shift(tarray,0,1)
w=where((dp(ndat-1,*) eq 0) and (dp(ndat-2,*) ne 1),ngood)
if (ngood ge 1) then begin
    totdt=total(dp(ndat-2,w))-ngood
    if totdt gt 0 then begin	; a subtle case, but it happens!
	dp=0
	storeres=fltarr(ndat,totdt)
	count = 0
	for i=0L,ngood-1L do begin
		dt = tarray(ndat-2,w(i)) - tarray(ndat-2,w(i)-1) 
		timer = tarray(ndat-2,w(i)-1) + findgen(1,dt-1) +1
		storeres(ndat-1,count:count+dt-2) = tarray(ndat-1,w(i)-1)
		storeres(ndat-2,count:count+dt-2) = timer 
		count = count + dt - 1
	endfor
	tarray = [[tarray],[storeres]]
	; watch out on other platforms' sorts!
	tarray = tarray(*,sort(tarray(ndat-2,*)))
	tarray = tarray(*,sort(tarray(ndat-1,*)))
    endif
endif
end
;
;	A little routine for making pdf's,
;	it takes the 'new-style' output from track.
;
function makepdf,tracks,dt,dim=dim,erode=erode,careful=careful

if (not keyword_set(dim)) then dim=2

; read the gdf file if 'tracks' is a string
sz = size(tracks)
nz = n_elements(sz)
if sz(nz-2) eq 7 then begin
	f = findfile(tracks)
	if f(0) eq '' then message,'No Match: '+tracks
	nf = n_elements(f)
	filebased = 1
endif else begin
	filebased = 0
	nf = 1
endelse

for i=0,nf-1 do begin
	; get the data, if needed
	if filebased then begin
		message,'Reading file: '+f(i),/inf
		t = read_gdf(f(i))
	endif else t = tracks
	; do the interpolation
	ltrinterp,t

	; declare some arrays
	ncol = n_elements(t(*,0))

	; get the rows, we do all for dt le 3, 
	; and 'triple count' for bigger dts.
	st = shift(t,0,-dt)

	if not keyword_set(careful) then begin
		if keyword_set( erode ) then begin
			mask = fltarr((2*fix(erode))+1.)+1
			bad = dilate(reform(t(0,*) eq 0),mask)	
			bad = bad or shift(bad,-dt)		; oink!
			st2 = shift(t,0,erode)
			st3 = shift(t,0,-dt-erode)
			;we require that the point not be in a dilated 'bad'
			;mask (for gaps) nor within erode of an end. 
			w = where( (st(ncol-2,*)-t(ncol-2,*)) eq dt and $
			   (st(ncol-1,*)-t(ncol-1,*)) eq 0 and $
		  	   (st2(ncol-1,*)-t(ncol-1,*)) eq 0 and $
			   (st3(ncol-1,*)-t(ncol-1,*)) eq 0 and (not bad),nw)
		endif else begin
			w = where( (st(ncol-2,*)-t(ncol-2,*)) eq dt and $
			   (t(0,*) ne 0) and (st(0,*) ne 0) and $
			   (st(ncol-1,*)-t(ncol-1,*)) eq 0 ,nw)
		endelse
	endif else begin
		if keyword_set( erode ) then begin
			mask = fltarr((2*fix(erode))+1.)+1
			bad = dilate(reform(t(0,*) eq 0),mask)
			bad = bad or shift(bad,-dt)
			st2 = shift(t,0,erode)	
			st3 = shift(t,0,-dt-erode)
			;we require that the point not be in a dilated 'bad'
			;mask (for gaps) nor within erode of an end. 
			w = where( (st(ncol-2,*)-t(ncol-2,*)) eq dt and $
			   (st(ncol-1,*)-t(ncol-1,*)) eq 0 and $
		  	   (st2(ncol-1,*)-t(ncol-1,*)) eq 0 and $
			   (st3(ncol-1,*)-t(ncol-1,*)) eq 0 and (not bad) and $
			   (t(ncol-2,*) mod dt eq 0) ,nw)
		endif else begin
			w = where( (st(ncol-2,*)-t(ncol-2,*)) eq dt and $
			   (st(ncol-1,*)-t(ncol-1,*)) eq 0 and $
			   (t(0,*) ne 0) and (st(0,*) ne 0) and $
			   (t(ncol-2,*) mod dt eq 0) ,nw)
		endelse
	endelse

	; accumulate the dxyzs
	if i eq 0 then dxyz = t(0:dim-1,w) - st(0:dim-1,w) else $
		dxyz = [[dxyz],[ t(0:dim-1,w) - st(0:dim-1,w) ]]

endfor

return,dxyz

end