; big.pro,  started 7-9-98 by ERW
;
;
; "reform" added 7-24-06 by ERW
; 13 XII 06 G.C.:
;    /sample prevents interpolation so result is not 'smoothed'
;    out. It is also faster this way and avoids 'edge' issues.

function big,image,fix=fix,scale=scale, sample = sample
; 'image'  gets doubled in size

if (not keyword_set(scale)) then scale=2

s = size(reform(image))
if (s(0) eq 2) then begin
	; 2-D array
	result=rebin(reform(image),s(1)*scale,s(2)*scale, sample=sample)
endif else begin
	; 3-D array
	result=rebin(reform(image),s(1)*scale,s(2)*scale,s(3), sample=sample)
endelse
if (keyword_set(fix)) then begin
	a=bytarr(512,480)
	a(0:s(1)*2-1,0:s(2)*2-1) = result
	result=a
end
  
return, result
end


