function dilate, arr, struct, gray=gray

;
; Written by Kenneth Desmond Jan. 7, 2009
; See IDL Manual
; Always computes dilate as if image is gray scale
; 

xl = n_elements(struct[*,0])
yl = n_elements(struct[0,*])

out = arr

for i=0, xl-1 do begin
   for j=0, yl-1 do begin

      if struct[i,j] eq 1 then begin 
         out = out > kshift(arr,[i-xl/2, j-yl/2])
      endif

   endfor
endfor 

out[0:xl/2, *]=0
out[n_elements(out[*,0])-xl/2-1:n_elements(out[*,0])-1, *]=0
out[*, 0:yl]=0
out[*, n_elements(out[0, *])-yl/2-1:n_elements(out[0, *])-1]=0


return, out

end
