; cor.pro,  started 7-10-98 by ERW
;
; computes correlation between variables one,two -- they can be
; any dimension, should be the same size though.

function cor,one,two,debug=debug

so=size(one)
st=size(two)
if (so(0) ne st(0)) then message,"warning: different sizes",/inf
if (so(1) ne st(1)) then message,"warning: different sizes",/inf
if (so(2) ne st(2)) then message,"warning: different sizes",/inf

none=n_elements(one)
ntwo=n_elements(two)

if (keyword_set(debug)) then print,"none ntwo: ",none,ntwo

stdone=stddev(one)
stdtwo=stddev(two)

avgone=total(one)/none
avgtwo=total(two)/ntwo
if (keyword_set(debug)) then print,"std1 std2 avg1 avg2: ",stdone, $
		stdtwo,avgone,avgtwo

stdone=stddev(one)
stdtwo=stddev(two)

;sqrone=total(one*one)/none
;sqrtwo=total(two*two)/ntwo

onetwo=total(float(one)*float(two))/(float(none))

cor=(onetwo-avgone*avgtwo)/(stdone*stdtwo)
if (keyword_set(debug)) then print,"onetwo,cor: ",onetwo,cor


return,cor
end


