/*
 * Open Source Physics software is free software as described near the bottom of this code file.
 *
 * For additional information and documentation on Open Source Physics please see: 
 * <http://www.opensourcephysics.org/>
 */

package org.opensourcephysics.sip.ch03;
import java.awt.*;
import org.opensourcephysics.display.*;

/**
 * WorldRectangle demonstrates how to draw an object using a drawing panel's world coordinates.
 *
 * @author Wolfgang Christian, Jan Tobochnik, Harvey Gould
 * @version 1.0  05/16/05
 */
public class WorldRectangle implements Drawable {
  double left, top;     // position of rectangle in world coordinates
  double width, height; // size of rectangle in world units

  /**
   * Constructs a WorldRectangle with position and dimensions values given in world coordinates.
   *
   * @param left double
   * @param top double
   * @param width double
   * @param height double
   */
  public WorldRectangle(double left, double top, double width, double height) {
    this.left = left; // location of left edge
    this.top = top;   // location of top edge
    this.width = width;
    this.height = height;
  }

  /**
   * Draws this rectangle using a drawing panel's world coordinates.
   * Required to implement the Drawable interface.
   *
   * @param panel DrawingPanel
   * @param g Graphics
   */
  public void draw(DrawingPanel panel, Graphics g) {
    // This method implements the Drawable interface
    g.setColor(Color.RED); // set drawing color to red
    // convert from world to pixel coordinates
    int leftPixels = panel.xToPix(left);
    int topPixels = panel.yToPix(top);
    int widthPixels = (int) (panel.getXPixPerUnit()*width);
    int heightPixels = (int) (panel.getYPixPerUnit()*height);
    g.fillRect(leftPixels, topPixels, widthPixels, heightPixels); // draws rectangle
  }
}

/* 
 * Open Source Physics software is free software; you can redistribute
 * it and/or modify it under the terms of the GNU General Public License (GPL) as
 * published by the Free Software Foundation; either version 2 of the License,
 * or(at your option) any later version.

 * Code that uses any portion of the code in the org.opensourcephysics package
 * or any subpackage (subdirectory) of this package must must also be be released
 * under the GNU GPL license.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston MA 02111-1307 USA
 * or view the license online at http://www.gnu.org/copyleft/gpl.html
 *
 * Copyright (c) 2007  The Open Source Physics project
 *                     http://www.opensourcephysics.org
 */
